require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Sneaking"

-- Skill multipliers from wiki tables (stored as whole percents, not 0..1).
-- Footstep sound radius multiplier WHILE SNEAKING (applies on crouch base of 20% of normal).
-- L1..10 → 90, 80, 75, 70, 65, 60, 55, 50, 45, 40
local _SNEAK_NOISE_SKILL_MULT = { 90, 80, 75, 70, 65, 60, 55, 50, 45, 40 }

-- Detection chance multiplier WHILE SNEAKING (vs. base = 100%)
-- L1..10 → 108, 96, 90, 84, 78, 72, 66, 60, 54, 48
local _SNEAK_DETECT_MULT = { 108, 96, 90, 84, 78, 72, 66, 60, 54, 48 }

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    -- Footstep noise while crouched:
    -- Base crouch = 20% of normal, then apply skill multiplier (e.g., 90% at L1)
    local skillNoisePct = _SNEAK_NOISE_SKILL_MULT[lvl] or 100
    local effectiveNoisePct = math.floor((20 * (skillNoisePct / 100)) + 0.5) -- % of normal while crouched
    local noiseReductionVsNormal = math.max(0, 100 - effectiveNoisePct)      -- convert to "-%"

    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
    ctx.add(ST.getText("IGUI_DST_Sneaking_val_SneakNoise_Reduction", tostring(noiseReductionVsNormal or "-")))

    -- Detection while crouched: show delta vs base with sign
    local detectMultPct = _SNEAK_DETECT_MULT[lvl] or 100
    local detectDelta   = detectMultPct - 100 -- positive = worse, negative = better

    if detectDelta >= 0 then
        ctx.add(ST.getText("IGUI_DST_Sneaking_val_SneakDetect_Pos", tostring(math.abs(detectDelta))))
    else
        ctx.add(ST.getText("IGUI_DST_Sneaking_val_SneakDetect_Neg", tostring(math.abs(detectDelta))))
    end

    ctx.addSeparator()
    ctx.add(ST.getText("IGUI_DST_Sneaking_info_Stacks"))
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)